<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;
use Closure;

class VerifyCsrfToken extends Middleware
{
    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array<int, string>
     */

    protected $addHttpCookie = true;

    protected $except = [
        '/user/success','/user/cancel','/user/fail','/user/ipn','user/ipn/strip','user/ipn/paypal','user/ipn/paystack','user/ipn/razorpay','webhook',
        // Webhook endpoints for WhatsApp Node service
        'api/whatsapp/*',
        'webhook/*',
    ];

    /**
     * Handle an incoming request.
     * Provides better error handling for CSRF token mismatches
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            return parent::handle($request, $next);
        } catch (\Illuminate\Session\TokenMismatchException $e) {
            // For AJAX requests, return JSON with new token
            if ($request->ajax() || $request->wantsJson()) {
                return response()->json([
                    'error' => 'csrf_token_expired',
                    'message' => 'Your session has expired. Please refresh the page.',
                    'new_token' => csrf_token()
                ], 419);
            }

            // For installer routes, regenerate token and redirect back
            if ($request->is('install/*')) {
                $request->session()->regenerateToken();
                return redirect()->back()
                    ->withInput($request->except('_token', 'password', 'db_password'))
                    ->with('error', 'Session expired. Please try again.');
            }

            throw $e;
        }
    }
}
