<?php
/**
 * ScheduledSmsApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Utils;
use GuzzleHttp\RequestOptions;
use Infobip\ApiException;
use Infobip\Configuration;
use Infobip\HeaderSelector;
use Infobip\ObjectSerializer;

/**
 * ScheduledSmsApi Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */
class ScheduledSmsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
    * @param ClientInterface $client
    * @param Configuration   $config
    * @param HeaderSelector  $selector
    */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getScheduledSmsMessages
     *
     * Get scheduled SMS messages
     *
     * @param  string $bulkId bulkId (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse
     */
    public function getScheduledSmsMessages($bulkId)
    {
        list($response) = $this->getScheduledSmsMessagesWithHttpInfo($bulkId);
        return $response;
    }

    /**
     * Operation getScheduledSmsMessagesWithHttpInfo
     *
     * Get scheduled SMS messages
     *
     * @param  string $bulkId (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScheduledSmsMessagesWithHttpInfo($bulkId)
    {
        $request = $this->getScheduledSmsMessagesRequest($bulkId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getScheduledSmsMessagesResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getScheduledSmsMessagesApiException($e);
        }
    }

    /**
     * Operation getScheduledSmsMessagesAsync
     *
     * Get scheduled SMS messages
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScheduledSmsMessagesAsync($bulkId)
    {
        return $this->getScheduledSmsMessagesAsyncWithHttpInfo($bulkId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getScheduledSmsMessagesAsyncWithHttpInfo
     *
     * Get scheduled SMS messages
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScheduledSmsMessagesAsyncWithHttpInfo($bulkId)
    {
        $request = $this->getScheduledSmsMessagesRequest($bulkId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getScheduledSmsMessagesResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getScheduledSmsMessagesApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getScheduledSmsMessages'
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getScheduledSmsMessagesRequest($bulkId)
    {
        // verify the required parameter 'bulkId' is set
        if ($bulkId === null || (is_array($bulkId) && count($bulkId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bulkId when calling getScheduledSmsMessages'
            );
        }

        $resourcePath = '/sms/1/bulks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getScheduledSmsMessages'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getScheduledSmsMessagesResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsBulkResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getScheduledSmsMessages'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getScheduledSmsMessagesApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsBulkResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation getScheduledSmsMessagesStatus
     *
     * Get scheduled SMS messages status
     *
     * @param  string $bulkId bulkId (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse
     */
    public function getScheduledSmsMessagesStatus($bulkId)
    {
        list($response) = $this->getScheduledSmsMessagesStatusWithHttpInfo($bulkId);
        return $response;
    }

    /**
     * Operation getScheduledSmsMessagesStatusWithHttpInfo
     *
     * Get scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScheduledSmsMessagesStatusWithHttpInfo($bulkId)
    {
        $request = $this->getScheduledSmsMessagesStatusRequest($bulkId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getScheduledSmsMessagesStatusResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getScheduledSmsMessagesStatusApiException($e);
        }
    }

    /**
     * Operation getScheduledSmsMessagesStatusAsync
     *
     * Get scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScheduledSmsMessagesStatusAsync($bulkId)
    {
        return $this->getScheduledSmsMessagesStatusAsyncWithHttpInfo($bulkId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getScheduledSmsMessagesStatusAsyncWithHttpInfo
     *
     * Get scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScheduledSmsMessagesStatusAsyncWithHttpInfo($bulkId)
    {
        $request = $this->getScheduledSmsMessagesStatusRequest($bulkId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getScheduledSmsMessagesStatusResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getScheduledSmsMessagesStatusApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getScheduledSmsMessagesStatus'
     *
     * @param  string $bulkId (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getScheduledSmsMessagesStatusRequest($bulkId)
    {
        // verify the required parameter 'bulkId' is set
        if ($bulkId === null || (is_array($bulkId) && count($bulkId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bulkId when calling getScheduledSmsMessagesStatus'
            );
        }

        $resourcePath = '/sms/1/bulks/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getScheduledSmsMessagesStatus'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getScheduledSmsMessagesStatusResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsBulkStatusResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getScheduledSmsMessagesStatus'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getScheduledSmsMessagesStatusApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsBulkStatusResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation rescheduleSmsMessages
     *
     * Reschedule SMS messages
     *
     * @param  string $bulkId bulkId (required)
     * @param  \Infobip\Model\SmsBulkRequest $smsBulkRequest smsBulkRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse
     */
    public function rescheduleSmsMessages($bulkId, $smsBulkRequest = null)
    {
        list($response) = $this->rescheduleSmsMessagesWithHttpInfo($bulkId, $smsBulkRequest);
        return $response;
    }

    /**
     * Operation rescheduleSmsMessagesWithHttpInfo
     *
     * Reschedule SMS messages
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsBulkRequest $smsBulkRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function rescheduleSmsMessagesWithHttpInfo($bulkId, $smsBulkRequest = null)
    {
        $request = $this->rescheduleSmsMessagesRequest($bulkId, $smsBulkRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->rescheduleSmsMessagesResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->rescheduleSmsMessagesApiException($e);
        }
    }

    /**
     * Operation rescheduleSmsMessagesAsync
     *
     * Reschedule SMS messages
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsBulkRequest $smsBulkRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function rescheduleSmsMessagesAsync($bulkId, $smsBulkRequest = null)
    {
        return $this->rescheduleSmsMessagesAsyncWithHttpInfo($bulkId, $smsBulkRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation rescheduleSmsMessagesAsyncWithHttpInfo
     *
     * Reschedule SMS messages
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsBulkRequest $smsBulkRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function rescheduleSmsMessagesAsyncWithHttpInfo($bulkId, $smsBulkRequest = null)
    {
        $request = $this->rescheduleSmsMessagesRequest($bulkId, $smsBulkRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->rescheduleSmsMessagesResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->rescheduleSmsMessagesApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'rescheduleSmsMessages'
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsBulkRequest $smsBulkRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function rescheduleSmsMessagesRequest($bulkId, $smsBulkRequest = null)
    {
        // verify the required parameter 'bulkId' is set
        if ($bulkId === null || (is_array($bulkId) && count($bulkId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bulkId when calling rescheduleSmsMessages'
            );
        }

        $resourcePath = '/sms/1/bulks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            ['application/json', 'application/xml']
        );

        // for model (json/xml)
        if (isset($smsBulkRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($smsBulkRequest));
            } else {
                $httpBody = $smsBulkRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'rescheduleSmsMessages'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function rescheduleSmsMessagesResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsBulkResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'rescheduleSmsMessages'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function rescheduleSmsMessagesApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsBulkResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation updateScheduledSmsMessagesStatus
     *
     * Update scheduled SMS messages status
     *
     * @param  string $bulkId bulkId (required)
     * @param  \Infobip\Model\SmsUpdateStatusRequest $smsUpdateStatusRequest smsUpdateStatusRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse
     */
    public function updateScheduledSmsMessagesStatus($bulkId, $smsUpdateStatusRequest = null)
    {
        list($response) = $this->updateScheduledSmsMessagesStatusWithHttpInfo($bulkId, $smsUpdateStatusRequest);
        return $response;
    }

    /**
     * Operation updateScheduledSmsMessagesStatusWithHttpInfo
     *
     * Update scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsUpdateStatusRequest $smsUpdateStatusRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateScheduledSmsMessagesStatusWithHttpInfo($bulkId, $smsUpdateStatusRequest = null)
    {
        $request = $this->updateScheduledSmsMessagesStatusRequest($bulkId, $smsUpdateStatusRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->updateScheduledSmsMessagesStatusResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->updateScheduledSmsMessagesStatusApiException($e);
        }
    }

    /**
     * Operation updateScheduledSmsMessagesStatusAsync
     *
     * Update scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsUpdateStatusRequest $smsUpdateStatusRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateScheduledSmsMessagesStatusAsync($bulkId, $smsUpdateStatusRequest = null)
    {
        return $this->updateScheduledSmsMessagesStatusAsyncWithHttpInfo($bulkId, $smsUpdateStatusRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateScheduledSmsMessagesStatusAsyncWithHttpInfo
     *
     * Update scheduled SMS messages status
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsUpdateStatusRequest $smsUpdateStatusRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateScheduledSmsMessagesStatusAsyncWithHttpInfo($bulkId, $smsUpdateStatusRequest = null)
    {
        $request = $this->updateScheduledSmsMessagesStatusRequest($bulkId, $smsUpdateStatusRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->updateScheduledSmsMessagesStatusResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->updateScheduledSmsMessagesStatusApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'updateScheduledSmsMessagesStatus'
     *
     * @param  string $bulkId (required)
     * @param  \Infobip\Model\SmsUpdateStatusRequest $smsUpdateStatusRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateScheduledSmsMessagesStatusRequest($bulkId, $smsUpdateStatusRequest = null)
    {
        // verify the required parameter 'bulkId' is set
        if ($bulkId === null || (is_array($bulkId) && count($bulkId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bulkId when calling updateScheduledSmsMessagesStatus'
            );
        }

        $resourcePath = '/sms/1/bulks/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            ['application/json', 'application/xml']
        );

        // for model (json/xml)
        if (isset($smsUpdateStatusRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($smsUpdateStatusRequest));
            } else {
                $httpBody = $smsUpdateStatusRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'updateScheduledSmsMessagesStatus'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsBulkStatusResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function updateScheduledSmsMessagesStatusResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsBulkStatusResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'updateScheduledSmsMessagesStatus'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function updateScheduledSmsMessagesStatusApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsBulkStatusResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
