const path = require('path');
const fs = require('fs');

// Load .env file if exists
function loadEnvFile() {
  const envPath = path.resolve(__dirname, '.env');
  const env = { NODE_ENV: 'production' };

  try {
    if (fs.existsSync(envPath)) {
      const content = fs.readFileSync(envPath, 'utf8');
      content.split('\n').forEach(line => {
        const trimmed = line.trim();
        if (trimmed && !trimmed.startsWith('#')) {
          const [key, ...valueParts] = trimmed.split('=');
          if (key && valueParts.length > 0) {
            env[key.trim()] = valueParts.join('=').trim();
          }
        }
      });
    }
  } catch (e) {
    console.error('Failed to load .env:', e.message);
  }

  return env;
}

module.exports = {
  apps: [
    {
      name: 'xsender-whatsapp',
      script: './src/app.js',
      cwd: __dirname, // Ensure correct working directory
      instances: 1, // Single instance for WhatsApp sessions
      exec_mode: 'fork', // Fork mode (not cluster) for session persistence
      watch: false,
      max_memory_restart: '500M',
      env: loadEnvFile(),
      error_file: './logs/error.log',
      out_file: './logs/output.log',
      log_date_format: 'YYYY-MM-DD HH:mm:ss Z',
      merge_logs: true,
      autorestart: true,
      max_restarts: 10,
      min_uptime: '10s',
      listen_timeout: 10000,
      kill_timeout: 5000,
      // Wait before considering app "online"
      wait_ready: true,
      // Restart delay to prevent rapid restarts
      restart_delay: 3000,
    },
  ],
};
