import express from 'express';
import sessionsRoute from './sessions.route.js';
import messagesRoute from './messages.route.js';
import configRoute from './config.route.js';
import authenticate from '../middleware/auth.middleware.js';
import { successResponse } from '../utils/response.js';

const router = express.Router();

/**
 * Health check endpoint (no auth required)
 */
router.get('/health', (req, res) => {
  return successResponse(res, 200, 'XSender WhatsApp Service is running', {
    status: 'healthy',
    timestamp: new Date().toISOString(),
    uptime: process.uptime(),
  });
});

/**
 * API Info endpoint (no auth required)
 */
router.get('/', (req, res) => {
  return successResponse(res, 200, 'XSender WhatsApp Service API', {
    version: '2.0.0',
    powered_by: '@whiskeysockets/baileys',
    documentation: '/api/docs',
    endpoints: {
      sessions: '/sessions',
      messages: '/messages',
      health: '/health',
    },
  });
});

/**
 * Configuration endpoint (no auth - Laravel pushes config on startup)
 * Note: In production, you may want to add IP whitelisting here
 */
router.use('/config', configRoute);

/**
 * Protected routes (require API key authentication)
 */
router.use('/sessions', authenticate, sessionsRoute);
router.use('/messages', authenticate, messagesRoute);

export default router;
