import pino from 'pino';
import serverConfig from '../config/server.config.js';

const logger = pino({
  level: serverConfig.logging.level,
  transport: serverConfig.logging.pretty
    ? {
        target: 'pino-pretty',
        options: {
          colorize: true,
          translateTime: 'yyyy-mm-dd HH:MM:ss',
          ignore: 'pid,hostname',
        },
      }
    : undefined,
});

export default logger;
